
// MobileState
var MobileStateUnknown = 0;
var MobileStateNoDevice = 1;
var MobileStateDeviceConnecting = 2;
var MobileStateDeviceInUse = 3;
var MobileStateNoSim = 4;
var MobileStateEnterPin = 5;
var MobileStateEnterPuk = 6;
var MobileStateEnteringPinPuk = 7;
var MobileStateNoNetwork = 8;
var MobileStateNetworkDenied = 9;
var MobileStateNetworkNotRegistered = 10;
var MobileStateNetworkSearching = 11;
var MobileStateInternetConnected = 12;
var MobileStateInternetConnecting = 13;
var MobileStateInternetDisconnecting = 14;
var MobileStateReady = 15;
var MobileStateServiceUnavailable = 16;
var MobileStateUnsupportedSim = 17;

// MobileDeviceConnectionState
var MobileDeviceConnectionStateDisconnected = 0;
var MobileDeviceConnectionStateConnected = 1;
var MobileDeviceConnectionStateConnecting = 2;
var MobileDeviceConnectionStateInUse = 3;

// MobileInternetConnectionState
var MobileInternetConnectionStateDisconnected = 0;
var MobileInternetConnectionStateConnected = 1;
var MobileInternetConnectionStateConnecting = 2;
var MobileInternetConnectionStateDisconnecting = 3;

// MobileDeviceType
var MobileDeviceTypeUnknown = 0;
var MobileDeviceTypeDevice = 1;
var MobileDeviceTypeOption = 2;
var MobileDeviceTypeHuawei = 3;
var MobileDeviceTypeSonyEricsson = 4;
var MobileDeviceTypeZTE = 5;

// MobilePinType
var MobilePinTypeUnknown = 0;
var MobilePinTypeSimNotInserted = 1;
var MobilePinTypeSimBusy = 2;
var MobilePinTypeReady = 3;
var MobilePinTypeSimPin1 = 4;
var MobilePinTypeSimPin2 = 5;
var MobilePinTypeSimPuk = 6;
var MobilePinTypePhCorpPin = 7;

// MobileRegistrationStatus
var MobileRegistrationStatusNotRegistered = 0;
var MobileRegistrationStatusRegisteredHome = 1;
var MobileRegistrationStatusNotRegisteredSearching = 2;
var MobileRegistrationStatusDenied = 3;
var MobileRegistrationStatusUnknown = 4;
var MobileRegistrationStatusRoaming = 5;

// MobileTechnologyPreference
var MobileTechnologyPreferenceUnknown = 0;
var MobileTechnologyPreference3GPreferred = 1;
var MobileTechnologyPreference3GOnly = 2;
var MobileTechnologyPreference2GPreferred = 3;
var MobileTechnologyPreference2GOnly = 4;

// MobileNetCap
var MobileNetCapUnknown = 0;
var MobileNetCapGSM = 1;
var MobileNetCapGPRS = 2;
var MobileNetCapEGPRS = 3; //Edge
var MobileNetCapUMTS = 4; //WCDMA
var MobileNetCapHSPA = 5;
var MobileNetCapHSDPA = 6;
var MobileNetCapHSUPA = 7;
var MobileNetCapHSDPAHSUPA = 8;
var MobileNetCapTDSCDMA = 9;
var MobileNetCapHSPAPlus = 10;

// MobileDomainCap
var MobileDomainCapUnknown = 0;
var MobileDomainCapCS = 1;
var MobileDomainCapPS = 2;
var MobileDomainCapCSPS = 3;

// MobileNetMode
var MobileNetModeUnknown = -1;
var MobileNetModeAutomatic = 0;
var MobileNetModeManual = 1;
var MobileNetModeDeregister = 2;
var MobileNetModeSetOnly = 3;
var MobileNetModeManualAutomatic = 4;

// MobileAvailableNetworkStat	
var MobileAvailableNetworkStatUnknown = 0;
var MobileAvailableNetworkStatAvailable = 1;
var MobileAvailableNetworkStatCurrent = 2;
var MobileAvailableNetworkStatForbidden = 3;

// MobileAvailableNetworkAct
var MobileAvailableNetworkActUnknown = -1;
var MobileAvailableNetworkActGSM = 0;
var MobileAvailableNetworkActGSMC = 1;
var MobileAvailableNetworkActUTRAN = 2;
var MobileAvailableNetworkActEGPRS = 3;
var MobileAvailableNetworkActHSDPA = 4;
var MobileAvailableNetworkActHSUPA = 5;
var MobileAvailableNetworkActHSDPAHSUPA = 6;

// MobileSmsMessageType
var MobileSmsMessageTypeReceivedUnread = 0;
var MobileSmsMessageTypeReceivedRead=1;
var MobileSmsMessageTypeStoredUnsent=2;
var MobileSmsMessageTypeStoredSent=3;
var MobileSmsMessageTypeUnknown=6;

// MobileConnectState		
var MobileConnectStateDisconnected=0;			// Connection disconnected 
var MobileConnectStateConnected=1;				// Connection established 
var MobileConnectStateConnectOpen=2;			// Port successfully openned 
var MobileConnectStateConnectDevice=3;		// Link connected (ATD/CONNECT) 
var MobileConnectStateConnectAuthenticating=4;// Starting authentication 
var MobileConnectStateConnectAuthenticated=5;	// Authentication successfull 
var MobileConnectStateDisconnecting=6;			// Starting disconnect 
var MobileConnectStateError=7;					// Error during establishment 
var MobileConnectStateUnknown=8;

// MobileConnectReason
var MobileConnectReasonUnknown = 0;		// Unknown 
var MobileConnectReasonUserInitiated = 1;	// User initiated action 
var MobileConnectReasonCarrierLost = 2;	// Carrier lost during connection 
var MobileConnectReasonLCPFailed = 3;		// LCP config failed 
var MobileConnectReasonPAPFailed = 4;		// PAP Authentication failed 
var MobileConnectReasonIPCPFailed = 5;	// IPCP failed 
var MobileConnectReasonNoCarrier = 6;		// No Carrier during setup 
var MobileConnectReasonCMEError = 7;		// CME Error code, must be last entry in list 

var SmsTypeOfAddress_Unknown = 0;		//Unknown. This is used when the user or network has no a priori information about the numbering plan. In this case, the Address-Value field is organized according to the network dialling plan, e.g. prefix or escape digits might be present.
var SmsTypeOfAddress_International = 1;	//International number.
var SmsTypeOfAddress_National = 2;			//National number. Prefix or escape digits shall not be included.
var SmsTypeOfAddress_NetworkSpecific = 3;	//Network specific number. This is used to indicate administration/service number specific to the serving network, e.g. used to access an operator.
var SmsTypeOfAddress_Subscriber = 4;		//Subscriber number. This is used when a specific short number representation is stored in one or more SCs as part of a higher layer application. (Note that "Subscriber number" shall only be used in connection with the proper PID referring to this application).
var SmsTypeOfAddress_Alphanumeric = 5;		//Alphanumeric, (coded according to GSM TS 03.38 7-bit default alphabet)
var SmsTypeOfAddress_Abbreviated = 6;		//Abbreviated number
var SmsTypeOfAddress_Reserved = 7;			//Reserved for extension

var SmsNumberingPlanId_Unknown = 0;
var SmsNumberingPlanId_Telephone = 1;
var SmsNumberingPlanId_Data = 2;
var SmsNumberingPlanId_Telex = 3;
var SmsNumberingPlanId_National = 4;
var SmsNumberingPlanId_Private = 5;
var SmsNumberingPlanId_ERMES = 6;
var SmsNumberingPlanId_Reserved = 7;

var SmsDCSGroup_Unknown = 0;
var SmsDCSGroup_General = 1;
var SmsDCSGroup_Reserved = 2;
var SmsDCSGroup_SpecialDiscard = 3;
var SmsDCSGroup_SpecialStore = 4;
var SmsDCSGroup_SpecialStore2 = 5;
var SmsDCSGroup_DataCodingMessage = 6;

var SmsDCSTextCompression_Unknown = 0;
var SmsDCSTextCompression_Compressed = 1;
var SmsDCSTextCompression_Uncompressed = 2;

var SmsDCSAlphabet_Unknown = 0;
var SmsDCSAlphabet_Default = 1;				//7-bit Alphabet over 8-bit octets
var SmsDCSAlphabet_8Bit = 2;
var SmsDCSAlphabet_16Bit = 3;					//UCS2
var SmsDCSAlphabet_Reserved = 4;

var SmsDCSMessageClass_Unknown = 0;
var SmsDCSMessageClass_Alert = 1;				//ImmediateDisplay
var SmsDCSMessageClass_ME = 2;
var SmsDCSMessageClass_SIM = 3;
var SmsDCSMessageClass_TE = 4;

var SmsMessageTypeIndicator_Unknown = 0;
var SmsMessageTypeIndicator_Deliver = 1;
var SmsMessageTypeIndicator_Submit = 2;

var SmsValidityPeriodFormat_Unknown = 0;
var SmsValidityPeriodFormat_NotPresent = 1;	//TP-VP field not present
var SmsValidityPeriodFormat_Relative = 2;		//TP-VP field present. Relative format (one octet)
var SmsValidityPeriodFormat_Enhanced = 3;		//TP-VP field present. Enhanced format (7 octets)
var SmsValidityPeriodFormat_Absolute = 4;		//TP-VP field present. Absolute format (7 octets)


var SecurityTypeNone = 0;
var SecurityTypePap = 1;
var SecurityTypeChap = 2;

if (typeof String.prototype.startsWith != 'function')
{
	String.prototype.startsWith = function (str){
		return this.indexOf(str) == 0;
	};
}

function IsSupportedSim(globalInfo)
{
	if(!globalInfo || !globalInfo.simStatus || !globalInfo.simStatus.imsi)
		return false;

	var imsi = globalInfo.simStatus.imsi;
	
	if(imsi.startsWith("24412131")) //DNA Prepaid
	{
		return true;
	}
	else if(imsi.startsWith("2441216"))
	{
		return true;
	}
	else if(
			imsi.startsWith("50501") ||	//DEBUG: to remove Telstra
			imsi.startsWith("24008")		//DEBUG: to remove TelenorSE
		) 
	{
		return true;
	}
	else if(imsi.startsWith("244039")
		|| imsi.startsWith("244121")
		|| imsi.startsWith("24412"))
	{
		return true;
	}
	
	return false;
}

// Ported from Windows cleint logic
function GetMobileState(globalInfo)
{
	var mobileState = MobileStateUnknown;

	if(!globalInfo.MBBServiceEnabled)
		mobileState = MobileStateServiceUnavailable;
	else if(globalInfo.deviceConnectedState == MobileDeviceConnectionStateDisconnected) //!globalInfo.isDeviceConnected)
		mobileState = MobileStateNoDevice;
	else if(globalInfo.deviceConnectedState == MobileDeviceConnectionStateConnecting)
		mobileState = MobileStateDeviceConnecting;
	else if(globalInfo.deviceConnectedState == MobileDeviceConnectionStateInUse)
		mobileState = MobileStateDeviceInUse;
	else if(!globalInfo.simStatus.simInserted)
		mobileState = MobileStateNoSim;
	else if(globalInfo.isEnteringPinPuk)
		mobileState = MobileStateEnteringPinPuk;
	else if(globalInfo.simStatus.pinType == MobilePinTypeSimPin1)
		mobileState = MobileStateEnterPin;
	else if(globalInfo.simStatus.pinType == MobilePinTypeSimPuk)
		mobileState = MobileStateEnterPuk;
	else if(!IsSupportedSim(globalInfo))
		mobileState = MobileStateUnsupportedSim;		
	else if((globalInfo.networkRegistration.opCode == "" || globalInfo.networkRegistration.opCode == "0")
		&& globalInfo.networkRegistration.registrationStatus == MobileRegistrationStatusDenied)
	{
		mobileState = MobileStateNetworkDenied;
	}
	else if((globalInfo.networkRegistration.opCode=="" || globalInfo.networkRegistration.opCode == "0")
		&& globalInfo.internetConnectedState != MobileInternetConnectionStateConnected)
		mobileState = MobileStateNetworkNotRegistered;
	else if(globalInfo.networkRegistration.registrationStatus == MobileRegistrationStatusNotRegisteredSearching)
		mobileState = MobileStateNetworkSearching;
	else if(globalInfo.networkRegistration.opCode == ""
		|| globalInfo.networkRegistration.registrationStatus == MobileRegistrationStatusUnknown)
	{
		mobileState = MobileStateNoNetwork;
	}
	else if(globalInfo.internetConnectedState == MobileInternetConnectionStateConnected)
		mobileState = MobileStateInternetConnected;
	else if(globalInfo.internetConnectedState == MobileInternetConnectionStateConnecting /*|| PopupWindowExists(L"ROAMING")*/)
		mobileState = MobileStateInternetConnecting;
	else if(globalInfo.internetConnectedState == MobileInternetConnectionStateDisconnecting)
		mobileState = MobileStateInternetDisconnecting;
	else if(globalInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRegisteredHome
		|| globalInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming
		|| globalInfo.networkRegistration.registrationStatus == MobileRegistrationStatusNotRegistered)
	{
		mobileState = MobileStateReady;
	}
	else
	{
	}

	return mobileState;
}


/*
window.cefApplication.Mobile.GetInfo() Object Model

uid : (string)
State : (MobileState*)
ManagedConnection : (bool)
MBBServiceEnabled : (bool)
deviceCaps : (object)
	manufacturer : (string)
	model : (string)
	imei : (string)
	hardwareVersion : (string)
	hardwareRevision : (string)
	port : (string)
simStatus : (object)
	pinTriesRemaining : (int)
	pukTriesRemaining : (int)
	pinType : (MobilePinType*)
	imsi : (string)
	iccid : (string)
	msisdn : (string)
	simLockEnabled : (bool)
	simInserted : (bool)
networkRegistration : (object)
	opCode : (string)
	networkName : (string)
	locationAreaCode : (string)
	cellId : (string)
	registrationStatus : (MobileRegistrationStatus*)
	networkCap : (MobileNetCap*)
	domainCap : (MobileDomainCap*)
	networkMode : (MobileNetMode*)
connectionStatus : (object)
	BytesXmited : (int)
	BytesRcved : (int)
	FramesXmited : (int)
	FramesRcved : (int)
	Errors : (int)
	ConnectDuration : (int)
	Status : (MobileConnectState*)
	Reason : (MobileConnectReason*)
technologyPreference : (MobileTechnologyPreference*)
availableNetworks : (array of object)
	act : (MobileAvailableNetworkAct*)
	stat : (MobileAvailableNetworkStat*)
	longName : (string)
	shortName : (string)
	oper : (string)
smsList : (array of object)
	index : (int)
	type : (MobileSmsMessageType*)
		time : (string)
		timestamp: (string)
		text: (string)								
		senderNumber: (string)
		senderTypeOfAddress : (SmsTypeOfAddress*)
		senderNumberingPlanId : (SmsNumberingPlanId*)
		isConcatenated : (bool)
		isUnknownMessageType : (bool)
		concatenationID: (string)
		totalConcatenatedItems : (int)
		concatenationItemNumber : (int)
		countConcatenatedItemsAdded : (int)
		concatenationIndicies : (array of string)	
		validityPeriod : (int)
		smscTypeOfAddress : (SmsTypeOfAddress*)
		smscNumberingPlanId : (SmsNumberingPlanId*)
		dcsGroup : (SmsDCSGroup*)
		dcsTextCompression : (SmsDCSTextCompression*)
		dcsAlphabet : (SmsDCSAlphabet*)
		dcsMessageClass : (SmsDCSMessageClass*)
		tpRP : (bool)
		tpUDHI : (bool)
		tpSRI : (bool)
		tpMMS : (bool)
		tpSRR : (bool)
		tpVPF : (SmsValidityPeriodFormat*)
		tpRD : (bool)
		messageTypeIndicator : (SmsMessageTypeIndicator*)
		day : (int)
		month : (int)
		year : (int)
		hour : (int)
		minute : (int)
		second : (int)	
	message : (object)
	pdu : (string)
smsStorageInfo : (object)
	smscNumber : (string)
	memRead : (string)
	memWrite : (string)
	mem3 : (string)
	memReadSlotsUsed : (int)
	memReadSlotsAvailable : (int)
	memWriteSlotsUsed : (int)
	memWriteSlotsAvailable : (int)
sigalQuality : (object)
	signalStrength : (int)
	signalQualityRssi : (int)
	signalQualitydBm : (int)
	signalRscp : (int)
	signalEcNo : (int)
deviceConnectedState : (MobileDeviceConnectionState)
internetConnectedState : (MobileInternetConnectionState)
deviceCode : (string)

bool								isEnteringPinPuk;


*/

